APPLE1	=1

ASCONE	='1'
INMASK	=$7F		; mask out the high bit for keyboard input

ESC	=$1B		; escape
SP	=$20		; space
CR	=$0D		; carriage return
LF	=$0A		; line feed

FROM	=$50		; move from MISCL,H
TO	=$52		; to MISCL2,H
SIZEL	=$54
SIZEH	=$55

DEST	=$2000

ASSEM   =$F01C
	.if APPLE1
MOVE    =$F204
	.endif

	.org $A000
	.start MAIN

MAIN	
	JSR SHOW	; show the menu
	JSR GETCH	; get the input
	JSR OUTCH
	CMP #ESC
	BEQ .STOP
	SEC
	SBC #ASCONE	; subtract ASCII '1' to get offfset
	CMP #NUM	; Are we in range?
	BCS .CONT	; Too large
	TAX		; X now holds offset for the selected item
	JSR CRLF
	JSR SELECT	; jump to the appropriate routine
.CONT	JMP MAIN	; loop forever
.STOP	RTS
	
SHOW	
	JSR CRLF
	LDX #$FF	; data
.NEXT	INX
	LDA MNUDAT,X
	BNE .NOTEOL
	JSR CRLF
	JMP .NEXT
.NOTEOL	CMP #$FF
	BEQ .DONE
	JSR OUTCH
	JMP .NEXT
.DONE	RTS
	
SELECT	
	LDA SRCL,X
	STA FROM
	LDA SRCH,X
	STA FROM+1
	LDA SZL,X
	STA SIZEL
	LDA SZH,X
	STA SIZEH
	LDA #<DEST
	STA TO
	LDA #>DEST
	STA TO+1
	JSR MOVE
	JMP ASSEM
  	
; ****************************************
; I/O routines
; ****************************************

CRLF			; Go to a new line.
	LDA #CR		; "CR"
	.if APPLE1
	JMP OUTCH
	.else
	JSR OUTCH
	LDA #LF		; "LF" - is this needed for the Apple 1?
	JMP OUTCH
	.endif
	RTS

GETCH   		; Get a character from the keyboard.
	LDA KBDRDY
	.if APPLE1
	BPL GETCH
	LDA KBD
	AND #INMASK
	.else
	BEQ GETCH
	.endif
	RTS
	
; Menu data

NUM	=$04		; Number of options in the menu
MNUDAT	.ascii	"CHOOSE SOURCE TO LOAD"
	.byte	$00
	.ascii	"1. MASTERMIND"
	.byte	$00
	.ascii	"2. 100 GAME"
	.byte	$00
	.ascii	"3. NIM"	
	.byte	$00
	.ascii	"4. PASART"	
	.byte	$00
	.ascii	"> "
	.byte	$FF
	
MM
	.BYTE $54, $52, $49, $45, $53, $01, $3E, $24, $45, $32, $00, $52, $4E, $44, $4C, $01
	.BYTE $3E, $24, $45, $33, $00, $52, $4E, $44, $48, $01, $3E, $24, $45, $34, $00, $52
	.BYTE $4E, $44, $32, $4C, $01, $3E, $24, $45, $35, $00, $4E, $01, $3E, $24, $45, $36
	.BYTE $00, $47, $55, $45, $53, $53, $01, $3E, $24, $45, $42, $00, $02, $00, $43, $4F
	.BYTE $55, $54, $01, $3E, $24, $46, $46, $45, $46, $00, $50, $52, $42, $59, $54, $45
	.BYTE $01, $3E, $24, $46, $46, $44, $43, $00, $4B, $42, $44, $01, $3E, $24, $44, $30
	.BYTE $31, $30, $00, $53, $54, $52, $4F, $42, $45, $01, $3E, $24, $44, $30, $31, $31
	.BYTE $00, $02, $00, $4D, $53, $54, $4D, $4E, $44, $01, $4E, $24, $33, $30, $30, $00
	.BYTE $01, $36, $23, $24, $38, $00, $4D, $53, $47, $4C, $50, $01, $2E, $4D, $53, $47
	.BYTE $2D, $31, $2C, $58, $00, $01, $22, $43, $4F, $55, $54, $00, $01, $15, $00, $01
	.BYTE $20, $4D, $53, $47, $4C, $50, $00, $01, $35, $54, $52, $49, $45, $53, $00, $52
	.BYTE $4E, $44, $4C, $50, $01, $38, $52, $4E, $44, $4C, $00, $01, $20, $52, $4E, $44
	.BYTE $32, $00, $01, $38, $52, $4E, $44, $48, $00, $52, $4E, $44, $32, $01, $2E, $53
	.BYTE $54, $52, $4F, $42, $45, $00, $01, $1A, $52, $4E, $44, $4C, $50, $00, $01, $22
	.BYTE $43, $48, $41, $52, $49, $4E, $00, $4E, $58, $54, $52, $59, $01, $04, $00, $01
	.BYTE $10, $00, $01, $11, $00, $01, $2C, $54, $52, $49, $45, $53, $00, $01, $2D, $54
	.BYTE $52, $49, $45, $53, $00, $01, $0E, $00, $4E, $58, $54, $4C, $49, $4E, $01, $22
	.BYTE $43, $52, $4C, $46, $00, $01, $2E, $54, $52, $49, $45, $53, $00, $01, $22, $50
	.BYTE $52, $42, $59, $54, $45, $00, $01, $2E, $23, $24, $41, $30, $00, $01, $0B, $00
	.BYTE $01, $22, $43, $4F, $55, $54, $00, $01, $2E, $52, $4E, $44, $4C, $00, $01, $2D
	.BYTE $52, $4E, $44, $32, $4C, $00, $01, $2E, $52, $4E, $44, $48, $00, $01, $36, $23
	.BYTE $24, $35, $00, $44, $49, $47, $45, $4E, $01, $25, $4E, $2D, $31, $2C, $58, $00
	.BYTE $01, $26, $23, $24, $33, $00, $42, $49, $54, $47, $45, $4E, $01, $33, $00, $01
	.BYTE $32, $52, $4E, $44, $32, $4C, $00, $01, $32, $4E, $2D, $31, $2C, $58, $00, $01
	.BYTE $09, $00, $01, $20, $42, $49, $54, $47, $45, $4E, $00, $01, $15, $00, $01, $20
	.BYTE $44, $49, $47, $45, $4E, $00, $52, $44, $4B, $45, $59, $01, $22, $43, $48, $41
	.BYTE $52, $49, $4E, $00, $01, $2F, $23, $24, $39, $42, $00, $01, $21, $52, $45, $54
	.BYTE $00, $01, $22, $43, $4F, $55, $54, $00, $01, $2B, $23, $24, $42, $30, $00, $01
	.BYTE $2F, $23, $24, $38, $00, $01, $1F, $4E, $58, $54, $4C, $49, $4E, $00, $01, $2D
	.BYTE $47, $55, $45, $53, $53, $2B, $34, $2C, $58, $00, $01, $15, $00, $01, $28, $23
	.BYTE $24, $46, $42, $00, $01, $20, $52, $44, $4B, $45, $59, $00, $01, $26, $23, $24
	.BYTE $46, $42, $00, $01, $2E, $23, $24, $41, $30, $00, $50, $4C, $55, $53, $31, $01
	.BYTE $22, $43, $4F, $55, $54, $00, $50, $4C, $55, $53, $32, $01, $2E, $47, $55, $45
	.BYTE $53, $53, $2B, $35, $2C, $58, $00, $01, $2F, $4E, $2B, $35, $2C, $58, $00, $01
	.BYTE $20, $50, $4C, $55, $53, $33, $00, $01, $25, $4E, $2B, $35, $2C, $58, $00, $01
	.BYTE $2E, $23, $24, $41, $42, $00, $01, $2D, $47, $55, $45, $53, $53, $2B, $35, $2C
	.BYTE $58, $00, $01, $0D, $00, $01, $20, $50, $4C, $55, $53, $31, $00, $01, $36, $23
	.BYTE $24, $31, $31, $00, $01, $20, $4D, $53, $47, $4C, $50, $00, $50, $4C, $55, $53
	.BYTE $33, $01, $0F, $00, $01, $20, $50, $4C, $55, $53, $32, $00, $01, $26, $23, $24
	.BYTE $46, $42, $00, $4D, $49, $4E, $55, $53, $31, $01, $36, $47, $55, $45, $53, $53
	.BYTE $2B, $35, $2C, $59, $00, $01, $11, $00, $01, $36, $23, $24, $46, $42, $00, $4D
	.BYTE $49, $4E, $55, $53, $32, $01, $2F, $4E, $2B, $35, $2C, $58, $00, $01, $20, $4D
	.BYTE $49, $4E, $55, $53, $33, $00, $01, $25, $4E, $2B, $35, $2C, $58, $00, $01, $2E
	.BYTE $23, $24, $41, $44, $00, $01, $22, $43, $4F, $55, $54, $00, $4D, $49, $4E, $55
	.BYTE $53, $33, $01, $0F, $00, $01, $20, $4D, $49, $4E, $55, $53, $32, $00, $01, $0D
	.BYTE $00, $01, $20, $4D, $49, $4E, $55, $53, $31, $00, $01, $21, $4E, $58, $54, $52
	.BYTE $59, $00, $4D, $53, $47, $01, $43, $24, $42, $46, $00, $01, $43, $24, $44, $39
	.BYTE $00, $01, $43, $24, $43, $34, $00, $01, $43, $24, $43, $31, $00, $01, $43, $24
	.BYTE $43, $35, $00, $01, $43, $24, $44, $32, $00, $01, $43, $24, $38, $44, $00, $01
	.BYTE $43, $24, $38, $44, $00, $01, $43, $24, $43, $45, $00, $01, $43, $24, $43, $39
	.BYTE $00, $01, $43, $24, $44, $37, $00, $01, $43, $24, $41, $30, $00, $01, $43, $24
	.BYTE $44, $35, $00, $01, $43, $24, $43, $46, $00, $01, $43, $24, $44, $39, $00, $01
	.BYTE $43, $24, $41, $30, $00, $01, $43, $24, $41, $42, $00, $43, $52, $4C, $46, $01
	.BYTE $2E, $23, $24, $38, $44, $00, $01, $24, $43, $4F, $55, $54, $00, $43, $48, $41
	.BYTE $52, $49, $4E, $01, $2E, $53, $54, $52, $4F, $42, $45, $00, $01, $1A, $43, $48
	.BYTE $41, $52, $49, $4E, $00, $01, $2E, $4B, $42, $44, $00, $52, $45, $54, $01, $19
	.BYTE $00, $00
HG	
	.BYTE $45, $43, $48, $4F, $01, $3E, $24, $46, $46, $45, $46, $00, $50, $52, $48, $45
	.BYTE $58, $01, $3E, $24, $46, $46, $45, $35, $00, $4F, $55, $54, $48, $45, $58, $01
	.BYTE $3E, $24, $46, $46, $44, $43, $00, $4B, $42, $44, $01, $3E, $24, $44, $30, $31
	.BYTE $30, $00, $4B, $42, $44, $52, $44, $59, $01, $3E, $24, $44, $30, $31, $31, $00
	.BYTE $02, $00, $46, $41, $49, $4C, $01, $3E, $24, $46, $46, $00, $43, $52, $01, $3E
	.BYTE $24, $30, $44, $00, $53, $50, $01, $3E, $24, $32, $30, $00, $45, $53, $43, $01
	.BYTE $3E, $24, $31, $42, $00, $02, $00, $49, $4F, $42, $55, $46, $01, $3E, $24, $30
	.BYTE $30, $00, $53, $43, $52, $54, $43, $48, $01, $3E, $24, $30, $32, $00, $4D, $53
	.BYTE $47, $4C, $01, $3E, $24, $30, $33, $00, $4D, $53, $47, $48, $01, $3E, $24, $30
	.BYTE $34, $00, $53, $55, $4D, $01, $3E, $24, $30, $35, $00, $54, $41, $52, $47, $45
	.BYTE $54, $01, $3E, $24, $30, $36, $00, $54, $55, $52, $4E, $01, $3E, $24, $30, $37
	.BYTE $00, $02, $00, $4D, $41, $49, $4E, $01, $4E, $00, $01, $10, $00, $01, $22, $49
	.BYTE $4E, $49, $54, $00, $01, $24, $50, $4C, $41, $59, $00, $02, $00, $45, $52, $52
	.BYTE $4F, $52, $01, $54, $27, $49, $4E, $56, $41, $4C, $49, $44, $27, $00, $01, $43
	.BYTE $24, $30, $00, $59, $4F, $55, $01, $54, $27, $59, $4F, $55, $27, $00, $01, $43
	.BYTE $24, $30, $00, $57, $49, $4E, $01, $54, $27, $57, $49, $4E, $21, $27, $00, $01
	.BYTE $43, $24, $30, $00, $4C, $4F, $53, $45, $01, $54, $27, $4C, $4F, $53, $45, $21
	.BYTE $27, $00, $01, $43, $24, $30, $00, $43, $4D, $50, $50, $4C, $59, $01, $54, $27
	.BYTE $49, $27, $00, $01, $43, $53, $50, $00, $01, $54, $27, $50, $4C, $41, $59, $27
	.BYTE $00, $01, $43, $53, $50, $00, $01, $43, $24, $30, $00, $53, $55, $4D, $4C, $4E
	.BYTE $01, $54, $27, $53, $55, $4D, $27, $00, $01, $43, $53, $50, $00, $01, $54, $27
	.BYTE $49, $53, $27, $00, $01, $43, $53, $50, $00, $01, $43, $24, $30, $00, $02, $00
	.BYTE $50, $4C, $41, $59, $01, $4E, $00, $01, $38, $54, $55, $52, $4E, $00, $01, $22
	.BYTE $50, $52, $53, $55, $4D, $00, $01, $2E, $53, $55, $4D, $00, $01, $22, $50, $52
	.BYTE $56, $41, $4C, $00, $01, $2E, $54, $55, $52, $4E, $00, $01, $34, $00, $01, $1E
	.BYTE $2E, $50, $4C, $59, $52, $00, $01, $22, $4D, $59, $4E, $55, $4D, $00, $01, $20
	.BYTE $2E, $43, $4F, $4E, $54, $00, $2E, $50, $4C, $59, $52, $01, $22, $59, $52, $4E
	.BYTE $55, $4D, $00, $2E, $43, $4F, $4E, $54, $01, $02, $00, $01, $2C, $53, $55, $4D
	.BYTE $00, $01, $1F, $2E, $45, $4E, $44, $45, $44, $00, $01, $2D, $53, $55, $4D, $00
	.BYTE $01, $20, $50, $4C, $41, $59, $00, $2E, $45, $4E, $44, $45, $44, $01, $05, $00
	.BYTE $01, $05, $00, $01, $22, $43, $52, $4C, $46, $00, $01, $22, $50, $52, $53, $55
	.BYTE $4D, $00, $01, $2E, $23, $24, $31, $00, $01, $22, $50, $52, $48, $45, $58, $00
	.BYTE $01, $07, $00, $01, $22, $4F, $55, $54, $48, $45, $58, $00, $01, $22, $43, $52
	.BYTE $4C, $46, $00, $01, $22, $43, $52, $4C, $46, $00, $01, $22, $59, $4F, $55, $4F
	.BYTE $52, $49, $00, $01, $22, $4F, $55, $54, $53, $50, $00, $01, $07, $00, $01, $21
	.BYTE $2E, $57, $49, $4E, $00, $01, $2E, $23, $3C, $4C, $4F, $53, $45, $00, $01, $2D
	.BYTE $4D, $53, $47, $4C, $00, $01, $2E, $23, $3E, $4C, $4F, $53, $45, $00, $01, $2D
	.BYTE $4D, $53, $47, $48, $00, $01, $04, $00, $01, $1F, $2E, $53, $48, $4F, $57, $00
	.BYTE $2E, $57, $49, $4E, $01, $2E, $23, $3C, $57, $49, $4E, $00, $01, $2D, $4D, $53
	.BYTE $47, $4C, $00, $01, $2E, $23, $3E, $57, $49, $4E, $00, $01, $2D, $4D, $53, $47
	.BYTE $48, $00, $2E, $53, $48, $4F, $57, $01, $22, $53, $48, $57, $4D, $53, $47, $00
	.BYTE $01, $22, $43, $52, $4C, $46, $00, $01, $22, $43, $52, $4C, $46, $00, $01, $24
	.BYTE $4D, $41, $49, $4E, $00, $02, $00, $47, $45, $54, $43, $48, $01, $4E, $00, $01
	.BYTE $2E, $4B, $42, $44, $52, $44, $59, $00, $01, $1A, $47, $45, $54, $43, $48, $00
	.BYTE $01, $2E, $4B, $42, $44, $00, $01, $2A, $23, $24, $37, $46, $00, $01, $19, $00
	.BYTE $02, $00, $50, $52, $4F, $4D, $50, $54, $01, $4E, $00, $01, $2E, $23, $27, $2D
	.BYTE $27, $00, $01, $22, $45, $43, $48, $4F, $00, $4F, $55, $54, $53, $50, $01, $4E
	.BYTE $00, $01, $2E, $23, $53, $50, $00, $01, $24, $45, $43, $48, $4F, $00, $02, $00
	.BYTE $43, $52, $4C, $46, $01, $4E, $00, $01, $2E, $23, $43, $52, $00, $01, $24, $45
	.BYTE $43, $48, $4F, $00, $02, $00, $50, $52, $56, $41, $4C, $01, $4E, $00, $01, $2F
	.BYTE $23, $24, $31, $30, $00, $01, $1E, $2E, $4E, $4F, $54, $45, $4E, $00, $01, $22
	.BYTE $4F, $55, $54, $48, $45, $58, $00, $01, $20, $2E, $53, $4B, $49, $50, $00, $2E
	.BYTE $4E, $4F, $54, $45, $4E, $01, $22, $50, $52, $48, $45, $58, $00, $2E, $53, $4B
	.BYTE $49, $50, $01, $24, $43, $52, $4C, $46, $00, $02, $00, $53, $48, $57, $4D, $53
	.BYTE $47, $01, $4E, $00, $01, $26, $23, $24, $30, $00, $2E, $50, $52, $49, $4E, $54
	.BYTE $01, $2E, $28, $4D, $53, $47, $4C, $29, $2C, $59, $00, $01, $21, $2E, $44, $4F
	.BYTE $4E, $45, $00, $01, $22, $45, $43, $48, $4F, $00, $01, $0D, $00, $01, $20, $2E
	.BYTE $50, $52, $49, $4E, $54, $00, $2E, $44, $4F, $4E, $45, $01, $19, $00, $02, $00
	.BYTE $41, $53, $43, $32, $48, $58, $01, $4E, $00, $01, $2B, $23, $24, $33, $30, $00
	.BYTE $01, $2F, $23, $24, $30, $41, $00, $01, $1E, $2E, $56, $41, $4C, $49, $44, $00
	.BYTE $01, $2C, $23, $24, $38, $38, $00, $01, $2F, $23, $24, $46, $41, $00, $01, $1E
	.BYTE $2E, $45, $52, $52, $00, $01, $2A, $23, $24, $30, $46, $00, $2E, $56, $41, $4C
	.BYTE $49, $44, $01, $19, $00, $2E, $45, $52, $52, $01, $2E, $23, $46, $41, $49, $4C
	.BYTE $00, $01, $19, $00, $02, $00, $42, $59, $54, $32, $48, $58, $01, $4E, $00, $01
	.BYTE $2E, $49, $4F, $42, $55, $46, $2C, $58, $00, $01, $22, $41, $53, $43, $32, $48
	.BYTE $58, $00, $01, $2F, $23, $46, $41, $49, $4C, $00, $01, $21, $2E, $45, $52, $52
	.BYTE $00, $01, $05, $00, $01, $0F, $00, $01, $2E, $49, $4F, $42, $55, $46, $2C, $58
	.BYTE $00, $01, $22, $41, $53, $43, $32, $48, $58, $00, $01, $2F, $23, $46, $41, $49
	.BYTE $4C, $00, $01, $20, $2E, $43, $4F, $4E, $54, $00, $01, $07, $00, $01, $19, $00
	.BYTE $2E, $43, $4F, $4E, $54, $01, $2D, $53, $43, $52, $54, $43, $48, $00, $01, $07
	.BYTE $00, $01, $31, $00, $01, $31, $00, $01, $31, $00, $01, $31, $00, $01, $2C, $53
	.BYTE $43, $52, $54, $43, $48, $00, $01, $19, $00, $2E, $45, $52, $52, $01, $2E, $23
	.BYTE $46, $41, $49, $4C, $00, $01, $19, $00, $02, $00, $49, $4E, $49, $54, $01, $4E
	.BYTE $00, $01, $2E, $23, $24, $30, $00, $01, $2D, $54, $55, $52, $4E, $00, $01, $37
	.BYTE $54, $55, $52, $4E, $00, $01, $2D, $53, $55, $4D, $00, $01, $2D, $54, $41, $52
	.BYTE $47, $45, $54, $00, $01, $38, $54, $41, $52, $47, $45, $54, $00, $01, $19, $00
	.BYTE $02, $00, $4D, $59, $50, $4C, $41, $59, $01, $4E, $00, $01, $2E, $23, $3C, $43
	.BYTE $4D, $50, $50, $4C, $59, $00, $01, $2D, $4D, $53, $47, $4C, $00, $01, $2E, $23
	.BYTE $3E, $43, $4D, $50, $50, $4C, $59, $00, $01, $2D, $4D, $53, $47, $48, $00, $01
	.BYTE $22, $53, $48, $57, $4D, $53, $47, $00, $01, $19, $00, $02, $00, $4D, $59, $4E
	.BYTE $55, $4D, $01, $4E, $00, $01, $2E, $53, $55, $4D, $00, $01, $2F, $54, $41, $52
	.BYTE $47, $45, $54, $00, $01, $21, $2E, $42, $41, $44, $00, $01, $1B, $2E, $47, $4F
	.BYTE $4F, $44, $00, $01, $2E, $23, $24, $31, $31, $00, $01, $02, $00, $01, $2C, $54
	.BYTE $41, $52, $47, $45, $54, $00, $01, $2D, $54, $41, $52, $47, $45, $54, $00, $01
	.BYTE $24, $4D, $59, $4E, $55, $4D, $00, $2E, $42, $41, $44, $01, $2E, $53, $55, $4D
	.BYTE $00, $01, $2C, $54, $41, $52, $47, $45, $54, $00, $01, $2A, $23, $24, $30, $46
	.BYTE $00, $01, $20, $2E, $53, $48, $4F, $57, $00, $01, $2E, $23, $24, $30, $35, $00
	.BYTE $01, $20, $2E, $53, $48, $4F, $57, $00, $2E, $47, $4F, $4F, $44, $01, $2E, $54
	.BYTE $41, $52, $47, $45, $54, $00, $01, $04, $00, $01, $30, $53, $55, $4D, $00, $2E
	.BYTE $53, $48, $4F, $57, $01, $05, $00, $01, $05, $00, $01, $22, $4D, $59, $50, $4C
	.BYTE $41, $59, $00, $01, $07, $00, $01, $22, $50, $52, $56, $41, $4C, $00, $01, $07
	.BYTE $00, $01, $19, $00, $02, $00, $59, $52, $4E, $55, $4D, $01, $4E, $00, $01, $22
	.BYTE $50, $52, $4F, $4D, $50, $54, $00, $01, $36, $23, $24, $30, $00, $01, $35, $49
	.BYTE $4F, $42, $55, $46, $00, $01, $35, $49, $4F, $42, $55, $46, $2B, $31, $00, $2E
	.BYTE $4F, $4E, $45, $43, $48, $01, $22, $47, $45, $54, $43, $48, $00, $01, $2F, $23
	.BYTE $45, $53, $43, $00, $01, $21, $2E, $51, $55, $49, $54, $00, $01, $2F, $23, $43
	.BYTE $52, $00, $01, $21, $2E, $44, $4F, $4E, $45, $00, $01, $2F, $23, $27, $30, $27
	.BYTE $00, $01, $1B, $2E, $4F, $4E, $45, $43, $48, $00, $01, $2F, $23, $27, $39, $27
	.BYTE $2B, $31, $00, $01, $1A, $2E, $4F, $4E, $45, $43, $48, $00, $01, $2D, $49, $4F
	.BYTE $42, $55, $46, $2C, $58, $00, $01, $22, $45, $43, $48, $4F, $00, $01, $0F, $00
	.BYTE $01, $28, $23, $24, $32, $00, $01, $20, $2E, $4F, $4E, $45, $43, $48, $00, $2E
	.BYTE $44, $4F, $4E, $45, $01, $22, $43, $52, $4C, $46, $00, $01, $36, $23, $24, $30
	.BYTE $00, $01, $22, $42, $59, $54, $32, $48, $58, $00, $01, $21, $2E, $45, $52, $52
	.BYTE $00, $01, $2F, $23, $46, $41, $49, $4C, $00, $01, $21, $2E, $45, $52, $52, $00
	.BYTE $01, $2F, $23, $24, $31, $31, $00, $01, $1F, $2E, $45, $52, $52, $00, $01, $19
	.BYTE $00, $2E, $45, $52, $52, $01, $2E, $23, $3C, $45, $52, $52, $4F, $52, $00, $01
	.BYTE $2D, $4D, $53, $47, $4C, $00, $01, $2E, $23, $3E, $45, $52, $52, $4F, $52, $00
	.BYTE $01, $2D, $4D, $53, $47, $48, $00, $01, $22, $53, $48, $57, $4D, $53, $47, $00
	.BYTE $01, $22, $43, $52, $4C, $46, $00, $01, $24, $59, $52, $4E, $55, $4D, $00, $2E
	.BYTE $51, $55, $49, $54, $01, $07, $00, $01, $07, $00, $01, $19, $00, $02, $00, $50
	.BYTE $52, $53, $55, $4D, $01, $4E, $00, $01, $2E, $23, $3C, $53, $55, $4D, $4C, $4E
	.BYTE $00, $01, $2D, $4D, $53, $47, $4C, $00, $01, $2E, $23, $3E, $53, $55, $4D, $4C
	.BYTE $4E, $00, $01, $2D, $4D, $53, $47, $48, $00, $01, $24, $53, $48, $57, $4D, $53
	.BYTE $47, $00, $02, $00, $59, $4F, $55, $4F, $52, $49, $01, $4E, $00, $01, $2E, $54
	.BYTE $55, $52, $4E, $00, $01, $34, $00, $01, $1E, $2E, $59, $4F, $55, $00, $01, $2E
	.BYTE $23, $27, $49, $27, $00, $01, $24, $45, $43, $48, $4F, $00, $2E, $59, $4F, $55
	.BYTE $01, $2E, $23, $3C, $59, $4F, $55, $00, $01, $2D, $4D, $53, $47, $4C, $00, $01
	.BYTE $2E, $23, $3E, $59, $4F, $55, $00, $01, $2D, $4D, $53, $47, $48, $00, $01, $22
	.BYTE $53, $48, $57, $4D, $53, $47, $00, $01, $19, $00, $00
NIM
	.BYTE $4F, $55, $54, $43, $48, $01, $3E, $24, $46, $46, $45, $46, $00, $50, $52, $48
	.BYTE $45, $58, $01, $3E, $24, $46, $46, $45, $35, $00, $4F, $55, $54, $48, $45, $58
	.BYTE $01, $3E, $24, $46, $46, $44, $43, $00, $4B, $42, $44, $01, $3E, $24, $44, $30
	.BYTE $31, $30, $00, $4B, $42, $44, $52, $44, $59, $01, $3E, $24, $44, $30, $31, $31
	.BYTE $00, $02, $00, $46, $41, $49, $4C, $01, $3E, $24, $46, $46, $00, $43, $52, $01
	.BYTE $3E, $24, $30, $44, $00, $4C, $46, $01, $3E, $24, $30, $41, $00, $53, $50, $01
	.BYTE $3E, $24, $32, $30, $00, $45, $53, $43, $01, $3E, $24, $31, $42, $00, $02, $00
	.BYTE $53, $43, $52, $54, $43, $48, $01, $3E, $24, $31, $30, $00, $4D, $53, $47, $4C
	.BYTE $01, $3E, $24, $31, $31, $00, $4D, $53, $47, $48, $01, $3E, $24, $31, $32, $00
	.BYTE $54, $55, $52, $4E, $01, $3E, $24, $31, $33, $00, $4E, $01, $3E, $24, $31, $34
	.BYTE $00, $56, $41, $4C, $53, $01, $3E, $24, $31, $35, $00, $02, $00, $4D, $41, $49
	.BYTE $4E, $01, $4E, $00, $01, $22, $49, $4E, $49, $54, $00, $01, $24, $50, $4C, $41
	.BYTE $59, $00, $02, $00, $49, $4E, $56, $01, $54, $27, $49, $4E, $56, $41, $4C, $49
	.BYTE $44, $27, $00, $01, $43, $24, $30, $00, $59, $4F, $55, $01, $54, $27, $59, $4F
	.BYTE $55, $27, $00, $01, $43, $24, $30, $00, $57, $49, $4E, $01, $54, $27, $57, $49
	.BYTE $4E, $21, $27, $00, $01, $43, $24, $30, $00, $43, $4D, $50, $50, $4C, $59, $01
	.BYTE $54, $27, $49, $27, $00, $01, $43, $53, $50, $00, $54, $41, $4B, $45, $01, $54
	.BYTE $27, $54, $41, $4B, $45, $27, $00, $01, $43, $24, $30, $00, $46, $52, $4F, $4D
	.BYTE $01, $54, $27, $46, $52, $4F, $4D, $27, $00, $01, $43, $53, $50, $00, $48, $45
	.BYTE $41, $50, $01, $54, $27, $48, $45, $41, $50, $27, $00, $01, $43, $24, $30, $00
	.BYTE $48, $45, $41, $50, $53, $01, $54, $27, $53, $27, $00, $01, $43, $53, $50, $00
	.BYTE $01, $54, $27, $41, $52, $45, $27, $00, $01, $43, $24, $30, $00, $02, $00, $50
	.BYTE $4C, $41, $59, $01, $4E, $00, $01, $38, $54, $55, $52, $4E, $00, $01, $22, $50
	.BYTE $52, $48, $45, $41, $50, $00, $01, $2E, $54, $55, $52, $4E, $00, $01, $34, $00
	.BYTE $01, $1E, $2E, $50, $4C, $59, $52, $00, $01, $22, $4D, $59, $47, $4F, $00, $01
	.BYTE $04, $00, $01, $1F, $2E, $43, $4F, $4E, $54, $00, $2E, $50, $4C, $59, $52, $01
	.BYTE $22, $59, $52, $47, $4F, $00, $2E, $43, $4F, $4E, $54, $01, $22, $43, $52, $4C
	.BYTE $46, $00, $01, $36, $4E, $00, $2E, $43, $48, $45, $43, $4B, $01, $2E, $56, $41
	.BYTE $4C, $53, $2D, $31, $2C, $58, $00, $01, $20, $50, $4C, $41, $59, $00, $01, $15
	.BYTE $00, $01, $20, $2E, $43, $48, $45, $43, $4B, $00, $01, $22, $50, $52, $48, $45
	.BYTE $41, $50, $00, $01, $22, $43, $52, $4C, $46, $00, $01, $22, $59, $4F, $55, $4F
	.BYTE $52, $49, $00, $01, $22, $4F, $55, $54, $53, $50, $00, $2E, $57, $49, $4E, $01
	.BYTE $2E, $23, $3C, $57, $49, $4E, $00, $01, $2D, $4D, $53, $47, $4C, $00, $01, $2E
	.BYTE $23, $3E, $57, $49, $4E, $00, $01, $2D, $4D, $53, $47, $48, $00, $01, $22, $53
	.BYTE $48, $57, $4D, $53, $47, $00, $01, $22, $43, $52, $4C, $46, $00, $01, $22, $43
	.BYTE $52, $4C, $46, $00, $01, $24, $4D, $41, $49, $4E, $00, $02, $00, $47, $45, $54
	.BYTE $43, $48, $01, $4E, $00, $01, $2E, $4B, $42, $44, $52, $44, $59, $00, $01, $1A
	.BYTE $47, $45, $54, $43, $48, $00, $01, $2E, $4B, $42, $44, $00, $01, $2A, $23, $24
	.BYTE $37, $46, $00, $01, $2F, $23, $45, $53, $43, $00, $01, $20, $2E, $4F, $55, $54
	.BYTE $00, $01, $07, $00, $01, $07, $00, $01, $07, $00, $01, $07, $00, $01, $07, $00
	.BYTE $01, $07, $00, $01, $19, $00, $2E, $4F, $55, $54, $01, $24, $4F, $55, $54, $43
	.BYTE $48, $00, $02, $00, $50, $52, $4F, $4D, $50, $54, $01, $4E, $00, $01, $2E, $23
	.BYTE $27, $3F, $27, $00, $01, $22, $4F, $55, $54, $43, $48, $00, $4F, $55, $54, $53
	.BYTE $50, $01, $4E, $00, $01, $2E, $23, $53, $50, $00, $01, $24, $4F, $55, $54, $43
	.BYTE $48, $00, $02, $00, $43, $52, $4C, $46, $01, $4E, $00, $01, $2E, $23, $43, $52
	.BYTE $00, $01, $24, $4F, $55, $54, $43, $48, $00, $02, $00, $53, $48, $57, $4D, $53
	.BYTE $47, $01, $4E, $00, $01, $26, $23, $24, $30, $00, $2E, $50, $52, $49, $4E, $54
	.BYTE $01, $2E, $28, $4D, $53, $47, $4C, $29, $2C, $59, $00, $01, $21, $2E, $44, $4F
	.BYTE $4E, $45, $00, $01, $22, $4F, $55, $54, $43, $48, $00, $01, $0D, $00, $01, $20
	.BYTE $2E, $50, $52, $49, $4E, $54, $00, $2E, $44, $4F, $4E, $45, $01, $19, $00, $02
	.BYTE $00, $41, $53, $43, $32, $48, $58, $01, $4E, $00, $01, $2B, $23, $24, $33, $30
	.BYTE $00, $01, $2F, $23, $24, $30, $41, $00, $01, $1E, $2E, $56, $41, $4C, $49, $44
	.BYTE $00, $01, $2C, $23, $24, $38, $38, $00, $01, $2F, $23, $24, $46, $41, $00, $01
	.BYTE $1E, $2E, $45, $52, $52, $00, $01, $2A, $23, $24, $30, $46, $00, $2E, $56, $41
	.BYTE $4C, $49, $44, $01, $19, $00, $2E, $45, $52, $52, $01, $2E, $23, $46, $41, $49
	.BYTE $4C, $00, $01, $19, $00, $02, $00, $45, $52, $52, $4F, $52, $01, $4E, $00, $01
	.BYTE $22, $43, $52, $4C, $46, $00, $01, $2E, $23, $3C, $49, $4E, $56, $00, $01, $2D
	.BYTE $4D, $53, $47, $4C, $00, $01, $2E, $23, $3E, $49, $4E, $56, $00, $01, $2D, $4D
	.BYTE $53, $47, $48, $00, $01, $22, $53, $48, $57, $4D, $53, $47, $00, $01, $24, $43
	.BYTE $52, $4C, $46, $00, $53, $48, $57, $48, $50, $01, $4E, $00, $01, $2E, $23, $3C
	.BYTE $48, $45, $41, $50, $00, $01, $2D, $4D, $53, $47, $4C, $00, $01, $2E, $23, $3E
	.BYTE $48, $45, $41, $50, $00, $01, $2D, $4D, $53, $47, $48, $00, $01, $24, $53, $48
	.BYTE $57, $4D, $53, $47, $00, $02, $00, $47, $45, $54, $4E, $4D, $4D, $01, $4E, $00
	.BYTE $01, $22, $53, $48, $57, $4D, $53, $47, $00, $47, $45, $54, $4E, $4D, $01, $22
	.BYTE $50, $52, $4F, $4D, $50, $54, $00, $01, $22, $47, $45, $54, $43, $48, $00, $01
	.BYTE $24, $41, $53, $43, $32, $48, $58, $00, $02, $00, $49, $4E, $49, $54, $01, $4E
	.BYTE $00, $01, $2E, $23, $24, $30, $00, $01, $2D, $54, $55, $52, $4E, $00, $01, $37
	.BYTE $54, $55, $52, $4E, $00, $02, $00, $2E, $52, $50, $54, $01, $22, $43, $52, $4C
	.BYTE $46, $00, $01, $22, $53, $48, $57, $48, $50, $00, $01, $2E, $23, $27, $53, $27
	.BYTE $00, $01, $22, $4F, $55, $54, $43, $48, $00, $01, $22, $47, $45, $54, $4E, $4D
	.BYTE $00, $01, $13, $00, $01, $21, $2E, $45, $52, $52, $00, $01, $2F, $23, $46, $41
	.BYTE $49, $4C, $00, $01, $21, $2E, $45, $52, $52, $00, $01, $35, $4E, $00, $2E, $52
	.BYTE $50, $54, $31, $01, $26, $23, $27, $31, $27, $00, $01, $36, $23, $24, $30, $00
	.BYTE $2E, $4E, $45, $58, $54, $01, $22, $43, $52, $4C, $46, $00, $01, $0A, $00, $01
	.BYTE $22, $4F, $55, $54, $43, $48, $00, $01, $22, $47, $45, $54, $4E, $4D, $00, $01
	.BYTE $2F, $23, $24, $30, $00, $01, $21, $2E, $45, $52, $52, $31, $00, $01, $2F, $23
	.BYTE $46, $41, $49, $4C, $00, $01, $21, $2E, $45, $52, $52, $31, $00, $01, $2D, $56
	.BYTE $41, $4C, $53, $2C, $58, $00, $01, $0D, $00, $01, $0F, $00, $01, $28, $4E, $00
	.BYTE $01, $20, $2E, $4E, $45, $58, $54, $00, $01, $22, $43, $52, $4C, $46, $00, $01
	.BYTE $19, $00, $2E, $45, $52, $52, $01, $22, $45, $52, $52, $4F, $52, $00, $01, $24
	.BYTE $2E, $52, $50, $54, $00, $2E, $45, $52, $52, $31, $01, $22, $45, $52, $52, $4F
	.BYTE $52, $00, $01, $24, $2E, $52, $50, $54, $31, $00, $02, $00, $43, $41, $4C, $43
	.BYTE $47, $4F, $01, $4E, $00, $02, $00, $01, $36, $4E, $00, $01, $2E, $23, $24, $30
	.BYTE $00, $2E, $4E, $45, $58, $54, $01, $2B, $56, $41, $4C, $53, $2D, $31, $2C, $58
	.BYTE $00, $01, $15, $00, $01, $20, $2E, $4E, $45, $58, $54, $00, $01, $2D, $53, $43
	.BYTE $52, $54, $43, $48, $00, $01, $2F, $23, $24, $30, $00, $01, $21, $2E, $42, $41
	.BYTE $44, $00, $01, $36, $4E, $00, $2E, $4E, $45, $58, $54, $32, $01, $2E, $53, $43
	.BYTE $52, $54, $43, $48, $00, $01, $2B, $56, $41, $4C, $53, $2D, $31, $2C, $58, $00
	.BYTE $01, $2F, $56, $41, $4C, $53, $2D, $31, $2C, $58, $00, $01, $1B, $2E, $47, $4F
	.BYTE $4F, $44, $00, $01, $15, $00, $01, $20, $2E, $4E, $45, $58, $54, $32, $00, $2E
	.BYTE $47, $4F, $4F, $44, $01, $2D, $53, $43, $52, $54, $43, $48, $00, $01, $2E, $56
	.BYTE $41, $4C, $53, $2D, $31, $2C, $58, $00, $01, $04, $00, $01, $30, $53, $43, $52
	.BYTE $54, $43, $48, $00, $01, $19, $00, $2E, $42, $41, $44, $01, $36, $4E, $00, $2E
	.BYTE $4E, $45, $58, $54, $33, $01, $2E, $56, $41, $4C, $53, $2C, $58, $00, $01, $20
	.BYTE $2E, $4F, $4B, $00, $01, $15, $00, $01, $20, $2E, $4E, $45, $58, $54, $33, $00
	.BYTE $2E, $4F, $4B, $01, $2E, $23, $24, $31, $00, $01, $19, $00, $02, $00, $4D, $59
	.BYTE $47, $4F, $01, $4E, $00, $01, $2E, $23, $3C, $43, $4D, $50, $50, $4C, $59, $00
	.BYTE $01, $2D, $4D, $53, $47, $4C, $00, $01, $2E, $23, $3E, $43, $4D, $50, $50, $4C
	.BYTE $59, $00, $01, $2D, $4D, $53, $47, $48, $00, $01, $22, $53, $48, $57, $4D, $53
	.BYTE $47, $00, $01, $22, $4F, $55, $54, $53, $50, $00, $01, $22, $43, $41, $4C, $43
	.BYTE $47, $4F, $00, $01, $2D, $53, $43, $52, $54, $43, $48, $00, $01, $22, $50, $52
	.BYTE $48, $45, $58, $00, $01, $22, $4F, $55, $54, $53, $50, $00, $01, $2E, $23, $3C
	.BYTE $46, $52, $4F, $4D, $00, $01, $2D, $4D, $53, $47, $4C, $00, $01, $2E, $23, $3E
	.BYTE $46, $52, $4F, $4D, $00, $01, $2D, $4D, $53, $47, $48, $00, $01, $22, $53, $48
	.BYTE $57, $4D, $53, $47, $00, $01, $22, $4F, $55, $54, $53, $50, $00, $01, $11, $00
	.BYTE $01, $22, $50, $52, $48, $45, $58, $00, $01, $15, $00, $55, $50, $44, $54, $48
	.BYTE $50, $01, $4E, $00, $01, $2E, $56, $41, $4C, $53, $2C, $58, $00, $01, $04, $00
	.BYTE $01, $30, $53, $43, $52, $54, $43, $48, $00, $01, $2D, $56, $41, $4C, $53, $2C
	.BYTE $58, $00, $01, $22, $43, $52, $4C, $46, $00, $01, $19, $00, $02, $00, $59, $52
	.BYTE $47, $4F, $01, $4E, $00, $01, $22, $53, $48, $57, $48, $50, $00, $01, $22, $47
	.BYTE $45, $54, $4E, $4D, $00, $01, $13, $00, $01, $21, $2E, $45, $52, $52, $00, $01
	.BYTE $28, $23, $46, $41, $49, $4C, $00, $01, $21, $2E, $45, $52, $52, $00, $01, $28
	.BYTE $4E, $00, $01, $21, $2E, $4F, $4B, $00, $01, $1F, $2E, $45, $52, $52, $00, $2E
	.BYTE $4F, $4B, $01, $15, $00, $01, $22, $43, $52, $4C, $46, $00, $01, $2E, $23, $3C
	.BYTE $54, $41, $4B, $45, $00, $01, $2D, $4D, $53, $47, $4C, $00, $01, $2E, $23, $3E
	.BYTE $54, $41, $4B, $45, $00, $01, $2D, $4D, $53, $47, $48, $00, $01, $22, $47, $45
	.BYTE $54, $4E, $4D, $4D, $00, $01, $2F, $23, $24, $30, $00, $01, $21, $2E, $45, $52
	.BYTE $52, $00, $01, $2F, $23, $46, $41, $49, $4C, $00, $01, $21, $2E, $45, $52, $52
	.BYTE $00, $01, $2F, $56, $41, $4C, $53, $2C, $58, $00, $01, $21, $2E, $55, $50, $44
	.BYTE $00, $01, $1F, $2E, $45, $52, $52, $00, $2E, $55, $50, $44, $01, $2D, $53, $43
	.BYTE $52, $54, $43, $48, $00, $01, $24, $55, $50, $44, $54, $48, $50, $00, $2E, $45
	.BYTE $52, $52, $01, $22, $45, $52, $52, $4F, $52, $00, $01, $24, $59, $52, $47, $4F
	.BYTE $00, $02, $00, $50, $52, $48, $45, $41, $50, $01, $4E, $00, $01, $22, $53, $48
	.BYTE $57, $48, $50, $00, $01, $2E, $23, $3C, $48, $45, $41, $50, $53, $00, $01, $2D
	.BYTE $4D, $53, $47, $4C, $00, $01, $2E, $23, $3E, $48, $45, $41, $50, $53, $00, $01
	.BYTE $2D, $4D, $53, $47, $48, $00, $01, $22, $53, $48, $57, $4D, $53, $47, $00, $01
	.BYTE $36, $23, $24, $30, $00, $2E, $4E, $45, $58, $54, $01, $22, $4F, $55, $54, $53
	.BYTE $50, $00, $01, $2E, $56, $41, $4C, $53, $2C, $58, $00, $01, $22, $50, $52, $48
	.BYTE $45, $58, $00, $01, $0F, $00, $01, $28, $4E, $00, $01, $1B, $2E, $4E, $45, $58
	.BYTE $54, $00, $01, $22, $43, $52, $4C, $46, $00, $01, $19, $00, $02, $00, $59, $4F
	.BYTE $55, $4F, $52, $49, $01, $4E, $00, $01, $2E, $54, $55, $52, $4E, $00, $01, $34
	.BYTE $00, $01, $1E, $2E, $59, $4F, $55, $00, $01, $2E, $23, $27, $49, $27, $00, $01
	.BYTE $24, $4F, $55, $54, $43, $48, $00, $2E, $59, $4F, $55, $01, $2E, $23, $3C, $59
	.BYTE $4F, $55, $00, $01, $2D, $4D, $53, $47, $4C, $00, $01, $2E, $23, $3E, $59, $4F
	.BYTE $55, $00, $01, $2D, $4D, $53, $47, $48, $00, $2E, $53, $48, $4F, $57, $01, $22
	.BYTE $53, $48, $57, $4D, $53, $47, $00, $01, $19, $00, $00
PAS
	.BYTE $02, $00, $02, $00, $42, $53, $01, $3E, $24, $30, $38, $00, $53, $50, $01, $3E
	.BYTE $24, $32, $30, $00, $43, $52, $01, $3E, $24, $30, $44, $00, $4C, $46, $01, $3E
	.BYTE $24, $30, $41, $00, $45, $53, $43, $01, $3E, $24, $31, $42, $00, $49, $4E, $4D
	.BYTE $41, $53, $4B, $01, $3E, $24, $37, $46, $00, $46, $41, $49, $4C, $01, $3E, $24
	.BYTE $46, $46, $00, $02, $00, $02, $00, $41, $4C, $4F, $01, $3E, $24, $30, $30, $00
	.BYTE $41, $48, $49, $01, $3E, $24, $30, $31, $00, $53, $49, $5A, $45, $58, $01, $3E
	.BYTE $24, $30, $32, $00, $53, $49, $5A, $45, $59, $01, $3E, $24, $30, $33, $00, $53
	.BYTE $54, $59, $4C, $45, $01, $3E, $24, $30, $34, $00, $4D, $4F, $44, $01, $3E, $24
	.BYTE $30, $35, $00, $54, $45, $4D, $50, $4C, $4F, $01, $3E, $24, $30, $36, $00, $54
	.BYTE $45, $4D, $50, $48, $49, $01, $3E, $24, $30, $37, $00, $43, $55, $52, $56, $41
	.BYTE $4C, $01, $3E, $24, $30, $38, $00, $53, $41, $56, $58, $01, $3E, $24, $30, $39
	.BYTE $00, $53, $41, $56, $59, $01, $3E, $24, $30, $41, $00, $54, $45, $4D, $50, $58
	.BYTE $01, $3E, $24, $30, $42, $00, $54, $45, $4D, $50, $59, $01, $3E, $24, $30, $43
	.BYTE $00, $53, $43, $52, $54, $43, $48, $01, $3E, $24, $30, $44, $00, $49, $4E, $42
	.BYTE $55, $46, $01, $3E, $54, $45, $4D, $50, $4C, $4F, $00, $53, $59, $4D, $42, $4C
	.BYTE $53, $01, $3E, $24, $31, $30, $00, $02, $00, $4D, $41, $49, $4E, $01, $4E, $00
	.BYTE $01, $22, $43, $52, $4C, $46, $00, $01, $2E, $23, $53, $50, $00, $01, $2D, $53
	.BYTE $59, $4D, $42, $4C, $53, $00, $01, $2E, $23, $24, $30, $00, $01, $2D, $41, $4C
	.BYTE $4F, $00, $01, $2E, $23, $24, $31, $30, $00, $01, $2D, $41, $48, $49, $00, $01
	.BYTE $22, $49, $4E, $50, $55, $54, $53, $00, $01, $22, $43, $41, $4C, $43, $00, $01
	.BYTE $22, $44, $52, $41, $57, $00, $01, $22, $47, $45, $54, $43, $48, $00, $01, $2F
	.BYTE $23, $45, $53, $43, $00, $01, $20, $4D, $41, $49, $4E, $00, $01, $19, $00, $02
	.BYTE $00, $52, $4F, $57, $53, $5A, $01, $3E, $24, $36, $00, $52, $4F, $57, $53, $01
	.BYTE $43, $53, $50, $00, $01, $54, $27, $3F, $53, $57, $4F, $52, $27, $00, $43, $4F
	.BYTE $4C, $53, $5A, $01, $3E, $24, $39, $00, $43, $4F, $4C, $53, $01, $43, $53, $50
	.BYTE $00, $01, $54, $27, $3F, $53, $4E, $4D, $55, $4C, $4F, $43, $27, $00, $53, $59
	.BYTE $4D, $53, $5A, $01, $3E, $24, $39, $00, $53, $59, $4D, $53, $01, $43, $53, $50
	.BYTE $00, $01, $54, $27, $3F, $53, $4C, $4F, $42, $4D, $59, $53, $27, $00, $53, $54
	.BYTE $59, $4C, $53, $5A, $01, $3E, $24, $46, $00, $53, $54, $59, $4C, $45, $53, $01
	.BYTE $43, $53, $50, $00, $01, $54, $27, $3F, $29, $33, $2C, $32, $2C, $31, $28, $27
	.BYTE $00, $01, $43, $53, $50, $00, $01, $54, $27, $45, $4C, $59, $54, $53, $27, $00
	.BYTE $02, $00, $49, $4E, $50, $55, $54, $53, $01, $4E, $00, $2E, $52, $4F, $57, $01
	.BYTE $36, $23, $52, $4F, $57, $53, $5A, $00, $2E, $4C, $4F, $4F, $50, $31, $01, $2E
	.BYTE $52, $4F, $57, $53, $2D, $31, $2C, $58, $00, $01, $22, $4F, $55, $54, $43, $48
	.BYTE $00, $01, $15, $00, $01, $20, $2E, $4C, $4F, $4F, $50, $31, $00, $01, $2E, $53
	.BYTE $49, $5A, $45, $58, $00, $01, $22, $49, $4E, $50, $55, $54, $00, $01, $2F, $23
	.BYTE $24, $33, $00, $01, $1B, $2E, $52, $4F, $57, $00, $01, $2D, $53, $49, $5A, $45
	.BYTE $58, $00, $01, $2D, $54, $45, $4D, $50, $58, $00, $2E, $43, $4F, $4C, $01, $36
	.BYTE $23, $43, $4F, $4C, $53, $5A, $00, $2E, $4C, $4F, $4F, $50, $32, $01, $2E, $43
	.BYTE $4F, $4C, $53, $2D, $31, $2C, $58, $00, $01, $22, $4F, $55, $54, $43, $48, $00
	.BYTE $01, $15, $00, $01, $20, $2E, $4C, $4F, $4F, $50, $32, $00, $01, $2E, $53, $49
	.BYTE $5A, $45, $59, $00, $01, $22, $49, $4E, $50, $55, $54, $00, $01, $2F, $23, $24
	.BYTE $33, $00, $01, $1B, $2E, $43, $4F, $4C, $00, $01, $2F, $23, $24, $32, $38, $00
	.BYTE $01, $1A, $2E, $43, $4F, $4C, $00, $01, $2D, $53, $49, $5A, $45, $59, $00, $01
	.BYTE $2D, $54, $45, $4D, $50, $59, $00, $2E, $53, $59, $4D, $01, $36, $23, $53, $59
	.BYTE $4D, $53, $5A, $00, $2E, $4C, $4F, $4F, $50, $33, $01, $2E, $53, $59, $4D, $53
	.BYTE $2D, $31, $2C, $58, $00, $01, $22, $4F, $55, $54, $43, $48, $00, $01, $15, $00
	.BYTE $01, $20, $2E, $4C, $4F, $4F, $50, $33, $00, $2E, $53, $4C, $4F, $4F, $50, $01
	.BYTE $22, $47, $45, $54, $43, $48, $00, $01, $2F, $23, $45, $53, $43, $00, $01, $20
	.BYTE $2E, $47, $45, $54, $00, $01, $07, $00, $01, $07, $00, $01, $19, $00, $2E, $47
	.BYTE $45, $54, $01, $2F, $23, $43, $52, $00, $01, $21, $2E, $4D, $4F, $44, $00, $01
	.BYTE $05, $00, $01, $22, $4F, $55, $54, $43, $48, $00, $01, $07, $00, $01, $0F, $00
	.BYTE $01, $2D, $53, $59, $4D, $42, $4C, $53, $2C, $58, $00, $01, $20, $2E, $53, $4C
	.BYTE $4F, $4F, $50, $00, $2E, $4D, $4F, $44, $01, $11, $00, $01, $21, $2E, $4B, $45
	.BYTE $45, $50, $00, $01, $0F, $00, $01, $35, $4D, $4F, $44, $00, $2E, $4B, $45, $45
	.BYTE $50, $01, $22, $43, $52, $4C, $46, $00, $2E, $53, $54, $59, $4C, $01, $36, $23
	.BYTE $53, $54, $59, $4C, $53, $5A, $00, $2E, $4C, $4F, $4F, $50, $34, $01, $2E, $53
	.BYTE $54, $59, $4C, $45, $53, $2D, $31, $2C, $58, $00, $01, $22, $4F, $55, $54, $43
	.BYTE $48, $00, $01, $15, $00, $01, $20, $2E, $4C, $4F, $4F, $50, $34, $00, $01, $38
	.BYTE $53, $54, $59, $4C, $45, $00, $01, $2E, $53, $54, $59, $4C, $45, $00, $01, $22
	.BYTE $49, $4E, $50, $55, $54, $00, $01, $21, $2E, $53, $54, $59, $4C, $00, $01, $2F
	.BYTE $23, $24, $34, $00, $01, $1A, $2E, $53, $54, $59, $4C, $00, $01, $2D, $53, $54
	.BYTE $59, $4C, $45, $00, $01, $37, $53, $54, $59, $4C, $45, $00, $2E, $44, $4F, $4E
	.BYTE $45, $01, $19, $00, $02, $00, $49, $4E, $50, $55, $54, $01, $4E, $00, $01, $2D
	.BYTE $53, $43, $52, $54, $43, $48, $00, $01, $36, $23, $24, $30, $00, $01, $35, $49
	.BYTE $4E, $42, $55, $46, $00, $01, $35, $49, $4E, $42, $55, $46, $2B, $31, $00, $01
	.BYTE $35, $49, $4E, $42, $55, $46, $2B, $32, $00, $2E, $4E, $45, $58, $54, $01, $22
	.BYTE $47, $45, $54, $43, $48, $00, $01, $2F, $23, $45, $53, $43, $00, $01, $20, $2E
	.BYTE $53, $4B, $49, $50, $00, $01, $07, $00, $01, $07, $00, $01, $07, $00, $01, $07
	.BYTE $00, $01, $19, $00, $2E, $53, $4B, $49, $50, $01, $22, $4F, $55, $54, $43, $48
	.BYTE $00, $01, $2F, $23, $43, $52, $00, $01, $21, $2E, $43, $56, $54, $00, $01, $2D
	.BYTE $49, $4E, $42, $55, $46, $2C, $58, $00, $01, $0F, $00, $01, $20, $2E, $4E, $45
	.BYTE $58, $54, $00, $2E, $43, $56, $54, $01, $11, $00, $01, $21, $2E, $53, $41, $4D
	.BYTE $45, $00, $01, $22, $42, $59, $54, $32, $44, $00, $01, $19, $00, $2E, $53, $41
	.BYTE $4D, $45, $01, $2E, $53, $43, $52, $54, $43, $48, $00, $01, $19, $00, $02, $00
	.BYTE $43, $41, $4C, $43, $01, $4E, $00, $01, $36, $23, $24, $31, $00, $01, $2E, $53
	.BYTE $54, $59, $4C, $45, $00, $01, $21, $2E, $4C, $4F, $4F, $50, $58, $00, $01, $2F
	.BYTE $23, $24, $31, $00, $01, $20, $2E, $53, $4B, $49, $50, $00, $01, $37, $54, $45
	.BYTE $4D, $50, $58, $00, $01, $20, $2E, $4C, $4F, $4F, $50, $58, $00, $2E, $53, $4B
	.BYTE $49, $50, $01, $2E, $53, $49, $5A, $45, $58, $00, $01, $33, $00, $01, $2C, $23
	.BYTE $24, $30, $00, $01, $2D, $54, $45, $4D, $50, $58, $00, $01, $2E, $53, $49, $5A
	.BYTE $45, $59, $00, $01, $33, $00, $01, $2C, $23, $24, $30, $00, $01, $2D, $54, $45
	.BYTE $4D, $50, $59, $00, $2E, $4C, $4F, $4F, $50, $58, $01, $26, $23, $24, $31, $00
	.BYTE $2E, $4C, $4F, $4F, $50, $59, $01, $2E, $23, $24, $30, $00, $01, $35, $53, $41
	.BYTE $56, $58, $00, $01, $25, $53, $41, $56, $59, $00, $01, $15, $00, $01, $22, $47
	.BYTE $45, $54, $56, $41, $4C, $00, $01, $2D, $43, $55, $52, $56, $41, $4C, $00, $01
	.BYTE $0F, $00, $01, $09, $00, $01, $22, $47, $45, $54, $56, $41, $4C, $00, $01, $0D
	.BYTE $00, $01, $02, $00, $01, $2C, $43, $55, $52, $56, $41, $4C, $00, $01, $22, $41
	.BYTE $4D, $4F, $44, $41, $00, $01, $05, $00, $01, $22, $47, $45, $54, $41, $44, $52
	.BYTE $00, $01, $07, $00, $01, $36, $23, $24, $30, $00, $01, $2D, $28, $54, $45, $4D
	.BYTE $50, $4C, $4F, $2C, $58, $29, $00, $01, $36, $53, $54, $59, $4C, $45, $00, $01
	.BYTE $21, $2E, $30, $00, $01, $15, $00, $01, $21, $2E, $31, $00, $01, $05, $00, $01
	.BYTE $36, $53, $41, $56, $58, $00, $01, $22, $59, $32, $43, $4D, $59, $00, $01, $22
	.BYTE $47, $45, $54, $41, $44, $52, $00, $01, $07, $00, $01, $05, $00, $01, $36, $23
	.BYTE $24, $30, $00, $01, $2D, $28, $54, $45, $4D, $50, $4C, $4F, $2C, $58, $29, $00
	.BYTE $01, $36, $53, $41, $56, $58, $00, $01, $26, $53, $41, $56, $59, $00, $01, $22
	.BYTE $58, $32, $52, $4D, $58, $00, $01, $22, $47, $45, $54, $41, $44, $52, $00, $01
	.BYTE $07, $00, $01, $05, $00, $01, $36, $23, $24, $30, $00, $01, $2D, $28, $54, $45
	.BYTE $4D, $50, $4C, $4F, $2C, $58, $29, $00, $01, $04, $00, $01, $1F, $2E, $43, $4F
	.BYTE $50, $59, $00, $2E, $31, $01, $05, $00, $01, $2E, $53, $49, $5A, $45, $59, $00 
	.BYTE $01, $04, $00, $01, $30, $53, $41, $56, $58, $00, $01, $2D, $54, $45, $4D, $50
	.BYTE $59, $00, $2E, $43, $4F, $50, $59, $01, $36, $53, $41, $56, $58, $00, $01, $22
	.BYTE $58, $32, $52, $4D, $58, $00, $01, $22, $59, $32, $43, $4D, $59, $00, $01, $22
	.BYTE $47, $45, $54, $41, $44, $52, $00, $01, $07, $00, $01, $36, $23, $24, $30, $00
	.BYTE $01, $2D, $28, $54, $45, $4D, $50, $4C, $4F, $2C, $58, $29, $00, $2E, $30, $01
	.BYTE $36, $53, $41, $56, $58, $00, $01, $26, $53, $41, $56, $59, $00, $01, $0D, $00
	.BYTE $01, $27, $54, $45, $4D, $50, $59, $00, $01, $20, $2E, $4C, $4F, $4F, $50, $59
	.BYTE $00, $01, $0F, $00, $01, $28, $54, $45, $4D, $50, $58, $00, $01, $20, $2E, $4C
	.BYTE $4F, $4F, $50, $58, $00, $01, $19, $00, $02, $00, $41, $4D, $4F, $44, $41, $01
	.BYTE $4E, $00, $01, $04, $00, $01, $30, $4D, $4F, $44, $00, $01, $21, $2E, $44, $4F
	.BYTE $4E, $45, $00, $01, $1A, $41, $4D, $4F, $44, $41, $00, $01, $02, $00, $01, $2C
	.BYTE $4D, $4F, $44, $00, $2E, $44, $4F, $4E, $45, $01, $19, $00, $02, $00, $58, $32
	.BYTE $52, $4D, $58, $01, $4E, $00, $02, $00, $01, $05, $00, $01, $2E, $53, $49, $5A
	.BYTE $45, $58, $00, $01, $04, $00, $01, $30, $53, $41, $56, $58, $00, $01, $13, $00
	.BYTE $01, $15, $00, $01, $07, $00, $01, $19, $00, $02, $00, $59, $32, $43, $4D, $59
	.BYTE $01, $4E, $00, $02, $00, $01, $05, $00, $01, $2E, $53, $49, $5A, $45, $59, $00
	.BYTE $01, $04, $00, $01, $30, $53, $41, $56, $59, $00, $01, $0B, $00, $01, $09, $00
	.BYTE $01, $07, $00, $01, $19, $00, $02, $00, $44, $52, $41, $57, $01, $4E, $00, $01
	.BYTE $36, $23, $24, $30, $00, $2E, $4C, $4F, $4F, $50, $58, $01, $26, $23, $24, $30
	.BYTE $00, $01, $22, $43, $52, $4C, $46, $00, $2E, $4C, $4F, $4F, $50, $59, $01, $22
	.BYTE $47, $45, $54, $56, $41, $4C, $00, $01, $35, $53, $41, $56, $58, $00, $01, $13
	.BYTE $00, $01, $2E, $53, $59, $4D, $42, $4C, $53, $2C, $58, $00, $01, $36, $53, $41
	.BYTE $56, $58, $00, $2E, $50, $52, $49, $4E, $54, $01, $22, $4F, $55, $54, $43, $48
	.BYTE $00, $01, $0D, $00, $01, $27, $53, $49, $5A, $45, $59, $00, $01, $20, $2E, $4C
	.BYTE $4F, $4F, $50, $59, $00, $01, $0F, $00, $01, $28, $53, $49, $5A, $45, $58, $00
	.BYTE $01, $20, $2E, $4C, $4F, $4F, $50, $58, $00, $01, $19, $00, $02, $00, $47, $45
	.BYTE $54, $56, $41, $4C, $01, $4E, $00, $02, $00, $01, $11, $00, $01, $21, $2E, $42
	.BYTE $4E, $44, $52, $59, $00, $01, $0A, $00, $01, $21, $2E, $42, $4E, $44, $52, $59
	.BYTE $00, $01, $2E, $53, $54, $59, $4C, $45, $00, $01, $21, $2E, $53, $4B, $49, $50
	.BYTE $00, $01, $11, $00, $01, $04, $00, $01, $30, $53, $49, $5A, $45, $58, $00, $01
	.BYTE $2F, $23, $24, $46, $46, $00, $01, $21, $2E, $42, $4E, $44, $52, $59, $00, $01
	.BYTE $0A, $00, $01, $04, $00, $01, $30, $53, $49, $5A, $45, $59, $00, $01, $2F, $23
	.BYTE $24, $46, $46, $00, $01, $21, $2E, $42, $4E, $44, $52, $59, $00, $2E, $53, $4B
	.BYTE $49, $50, $01, $22, $47, $45, $54, $41, $44, $52, $00, $01, $35, $53, $43, $52
	.BYTE $54, $43, $48, $00, $01, $36, $23, $24, $30, $00, $01, $2E, $28, $54, $45, $4D
	.BYTE $50, $4C, $4F, $2C, $58, $29, $00, $01, $36, $53, $43, $52, $54, $43, $48, $00
	.BYTE $01, $02, $00, $01, $1E, $2E, $44, $4F, $4E, $45, $00, $2E, $42, $4E, $44, $52
	.BYTE $59, $01, $2E, $23, $24, $31, $00, $2E, $44, $4F, $4E, $45, $01, $19, $00, $02
	.BYTE $00, $02, $00, $47, $45, $54, $41, $44, $52, $01, $4E, $00, $02, $00, $01, $11
	.BYTE $00, $01, $05, $00, $01, $2E, $41, $48, $49, $00, $01, $2D, $54, $45, $4D, $50
	.BYTE $48, $49, $00, $01, $2E, $41, $4C, $4F, $00, $01, $2D, $54, $45, $4D, $50, $4C
	.BYTE $4F, $00, $01, $28, $23, $24, $30, $00, $01, $21, $2E, $4E, $45, $58, $54, $00
	.BYTE $01, $02, $00, $2E, $4C, $4F, $4F, $50, $01, $2C, $53, $49, $5A, $45, $59, $00
	.BYTE $01, $2D, $54, $45, $4D, $50, $4C, $4F, $00, $01, $1E, $2E, $53, $4B, $49, $50
	.BYTE $00, $01, $38, $54, $45, $4D, $50, $48, $49, $00, $2E, $53, $4B, $49, $50, $01
	.BYTE $15, $00, $01, $20, $2E, $4C, $4F, $4F, $50, $00, $2E, $4E, $45, $58, $54, $01
	.BYTE $0A, $00, $01, $2C, $54, $45, $4D, $50, $4C, $4F, $00, $01, $2D, $54, $45, $4D
	.BYTE $50, $4C, $4F, $00, $01, $1E, $2E, $44, $4F, $4E, $45, $00, $01, $38, $54, $45
	.BYTE $4D, $50, $48, $49, $00, $2E, $44, $4F, $4E, $45, $01, $07, $00, $01, $13, $00
	.BYTE $01, $19, $00, $02, $00, $02, $00, $02, $00, $42, $59, $54, $32, $44, $01, $4E
	.BYTE $00, $02, $00, $01, $2E, $49, $4E, $42, $55, $46, $00, $01, $22, $2E, $41, $32
	.BYTE $44, $00, $01, $2F, $23, $46, $41, $49, $4C, $00, $01, $21, $2E, $45, $52, $52
	.BYTE $00, $01, $05, $00, $01, $2E, $49, $4E, $42, $55, $46, $2B, $31, $00, $01, $22
	.BYTE $2E, $41, $32, $44, $00, $01, $2F, $23, $46, $41, $49, $4C, $00, $01, $20, $2E
	.BYTE $43, $4F, $4E, $54, $00, $01, $07, $00, $01, $19, $00, $2E, $43, $4F, $4E, $54
	.BYTE $01, $2D, $53, $43, $52, $54, $43, $48, $00, $01, $07, $00, $01, $2D, $43, $55
	.BYTE $52, $56, $41, $4C, $00, $01, $31, $00, $01, $31, $00, $01, $02, $00, $01, $2C
	.BYTE $43, $55, $52, $56, $41, $4C, $00, $01, $31, $00, $01, $2C, $53, $43, $52, $54
	.BYTE $43, $48, $00, $01, $19, $00, $2E, $41, $32, $44, $01, $2B, $23, $24, $33, $30
	.BYTE $00, $01, $2F, $23, $24, $30, $41, $00, $01, $1E, $2E, $56, $41, $4C, $49, $44
	.BYTE $00, $2E, $45, $52, $52, $01, $2E, $23, $46, $41, $49, $4C, $00, $2E, $56, $41
	.BYTE $4C, $49, $44, $01, $19, $00, $02, $00, $02, $00, $02, $00, $43, $52, $4C, $46
	.BYTE $01, $4E, $00, $01, $2E, $23, $43, $52, $00, $01, $24, $4F, $55, $54, $43, $48
	.BYTE $00, $02, $00, $47, $45, $54, $43, $48, $01, $4E, $00, $01, $2E, $4B, $42, $44
	.BYTE $52, $44, $59, $00, $01, $1A, $47, $45, $54, $43, $48, $00, $01, $2E, $4B, $42
	.BYTE $44, $00, $01, $2A, $23, $49, $4E, $4D, $41, $53, $4B, $00, $01, $19, $00, $02
	.BYTE $00, $02, $00, $4F, $55, $54, $43, $48, $01, $3E, $24, $46, $46, $45, $46, $00
	.BYTE $50, $52, $48, $45, $58, $01, $3E, $24, $46, $46, $45, $35, $00, $4F, $55, $54
	.BYTE $48, $45, $58, $01, $3E, $24, $46, $46, $44, $43, $00, $4B, $42, $44, $01, $3E
	.BYTE $24, $44, $30, $31, $30, $00, $4B, $42, $44, $52, $44, $59, $01, $3E, $24, $44
	.BYTE $30, $31, $31, $00, $00
END

MMSZ = HG-MM
HGSZ = NIM-HG
NIMSZ = PAS-NIM
PASSZ = END-PAS

; tables
SRCL
	.byte <MM
	.byte <HG
	.byte <NIM
	.byte <PAS
SRCH
	.byte >MM
	.byte >HG
	.byte >NIM
	.byte >PAS
SZL
	.byte <MMSZ
	.byte <HGSZ
	.byte <NIMSZ
	.byte <PASSZ
SZH
	.byte >MMSZ
	.byte >HGSZ
	.byte >NIMSZ
	.byte >PASSZ

	.if APPLE1
; Apple 1 I/O values
OUTCH	=$FFEF		; Apple 1 Echo
PRHEX	=$FFE5		; Apple 1 Echo
OUTHEX	=$FFDC		; Apple 1 Print Hex Byte Routine
KBD     =$D010		; Apple 1 Keyboard character read.
KBDRDY  =$D011		; Apple 1 Keyboard data waiting when negative.
	.else
IOMEM	=$E000
PUTCH	=IOMEM+1
KBD	=IOMEM+4
KBDRDY  =IOMEM+4

	.ORG $FB82
MOVE			; Move memory down
	LDY #$00
	LDX SIZEH
	BEQ .MD2
.MD1	LDA (FROM),Y ; move a page at a time
	STA (TO),Y
	INY
	BNE .MD1
	INC FROM+1
	INC TO+1
	DEX
	BNE .MD1
.MD2	LDX SIZEL
	BEQ .MD4
.MD3	LDA (FROM),Y ; move the remaining bytes
	STA (TO),Y
	INY
	DEX
	BNE .MD3
.MD4	RTS

	.ORG $FFDC
OUTHEX	PHA 		; Print 1 hex byte. 
	LSR
	LSR 
	LSR
	LSR 
	JSR PRHEX
	PLA 
PRHEX	AND #$0F	; Print 1 hex digit
	ORA #$30
	CMP #$3A
	BCC OUTCH
	ADC #$06
OUTCH	STA PUTCH
	RTS  
	.endif